/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.condition.CargoThresholdCondition;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.lang.Lang;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedSlottedStorage;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class ItemThresholdCondition
extends CargoThresholdCondition {
    private FilterItemStack stack = FilterItemStack.empty();

    @Override
    protected class_2561 getUnit() {
        return class_2561.method_43470((String)(this.inStacks() ? "\u25a4" : ""));
    }

    @Override
    protected class_1799 getIcon() {
        return this.stack.item();
    }

    @Override
    protected boolean test(class_1937 level, Train train, class_2487 context) {
        CargoThresholdCondition.Ops operator = this.getOperator();
        long target = this.getThreshold();
        boolean stacks = this.inStacks();
        long foundItems = 0L;
        for (Carriage carriage : train.carriages) {
            CombinedSlottedStorage<ItemVariant, ? extends SlottedStorage<ItemVariant>> items = carriage.storage.getAllItems();
            for (StorageView view : items.nonEmptyViews()) {
                ItemVariant variant = (ItemVariant)view.getResource();
                if (!this.stack.test(level, variant.toStack())) continue;
                if (stacks) {
                    foundItems += view.getAmount() == (long)variant.getItem().method_7882() ? 1L : 0L;
                    continue;
                }
                foundItems += view.getAmount();
            }
        }
        this.requestStatusToUpdate(foundItems, context);
        return operator.test(foundItems, target);
    }

    @Override
    protected void writeAdditional(class_2487 tag) {
        super.writeAdditional(tag);
        tag.method_10566("Item", (class_2520)this.stack.serializeNBT());
    }

    @Override
    protected void readAdditional(class_2487 tag) {
        super.readAdditional(tag);
        if (tag.method_10545("Item")) {
            this.stack = FilterItemStack.of(tag.method_10562("Item"));
        }
    }

    @Override
    public boolean tickCompletion(class_1937 level, Train train, class_2487 context) {
        return super.tickCompletion(level, train, context);
    }

    @Override
    public void setItem(int slot, class_1799 stack) {
        this.stack = FilterItemStack.of(stack);
    }

    @Override
    public class_1799 getItem(int slot) {
        return this.stack.item();
    }

    @Override
    public List<class_2561> getTitleAs(String type) {
        return ImmutableList.of((Object)CreateLang.translateDirect("schedule.condition.threshold.train_holds", CreateLang.translateDirect("schedule.condition.threshold." + Lang.asId((String)this.getOperator().name()), new Object[0])), (Object)CreateLang.translateDirect("schedule.condition.threshold.x_units_of_item", this.getThreshold(), CreateLang.translateDirect("schedule.condition.threshold." + (this.inStacks() ? "stacks" : "items"), new Object[0]), this.stack.isEmpty() ? CreateLang.translateDirect("schedule.condition.threshold.anything", new Object[0]) : (this.stack.isFilterItem() ? CreateLang.translateDirect("schedule.condition.threshold.matching_content", new Object[0]) : this.stack.item().method_7964())).method_27692(class_124.field_1062));
    }

    private boolean inStacks() {
        return this.intData("Measure") == 1;
    }

    @Override
    public class_2960 getId() {
        return Create.asResource("item_threshold");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        super.initConfigurationWidgets(builder);
        builder.addSelectionScrollInput(71, 50, (i, l) -> i.forOptions((List<? extends class_2561>)ImmutableList.of((Object)CreateLang.translateDirect("schedule.condition.threshold.items", new Object[0]), (Object)CreateLang.translateDirect("schedule.condition.threshold.stacks", new Object[0]))).titled(CreateLang.translateDirect("schedule.condition.threshold.item_measure", new Object[0])), "Measure");
    }

    @Override
    public class_5250 getWaitingStatus(class_1937 level, Train train, class_2487 tag) {
        long lastDisplaySnapshot = this.getLastDisplaySnapshot(tag);
        if (lastDisplaySnapshot == -1L) {
            return class_2561.method_43473();
        }
        int offset = this.getOperator() == CargoThresholdCondition.Ops.LESS ? -1 : (this.getOperator() == CargoThresholdCondition.Ops.GREATER ? 1 : 0);
        return CreateLang.translateDirect("schedule.condition.threshold.status", lastDisplaySnapshot, Math.max(0L, this.getThreshold() + (long)offset), CreateLang.translateDirect("schedule.condition.threshold." + (this.inStacks() ? "stacks" : "items"), new Object[0]));
    }
}

